% Map Creation Guide

[Craig Brett link]: Craig Brett/Readme.html
[Victorious link]: Victorious/Readme.html
[Scripting Guide link]: Scripting.md.html

## Overview
My new focus with Tactical Battle is to make it an engine for map creators to create their own maps with cool themes and interesting ways of beating each map.
Editing levels is done by entering the Tactical Battle\\Data for TB\\Map Packs folder and editing text files.
Notepad comes installed on windows and is perfect for editing these files.
Ensure that "Word Wrap" is turned off in the "Format" menu of notepad.
Or if you want something more advanced you can try Notepad++ or EdSharp.
I recommend only changing a few things and then testing them as you go.  This way if you run into a bug you'll likely know where the mistake was made.
A good starting strategy is to copy the Getting Started Maps folder and paste it with a new name.
Then you can edit the maps in the new folder as much as you want and always have the original maps to refer to.
The Items and equipment example is also good after you've got the hang of the getting started maps.
There is also an in game map editor that lets you place units, structures and terrain quickly, see the map editor section for more details.  The in game map editor does not replace editing files completely, it just gives a nice way to position units, structures and terrain.

There is nothing like a good example to quickly get you up to speed so be sure to look through the existing files to get an idea for how things work.
Almost all the files have the type of the file as the first line and the version of the file parser as the second line.
You can use 2 slashes (//) and write comments to the right of them.
Comments are ignored by the parser.

## Step by step instructions for getting started
This section is intended to be a beginner's guide to getting your first map pack started and making some basic changes.
If you've already made a map you can skip ahead to the next sections which are a reference for all the files and their flags.

Note: If you do not see the .txt or .html file extensions it is because your computer is set up to hide file extensions.
This is not a problem, but when you create a new text document do not end it's name with the .txt extension since it already has this, it is just hidden from you.

1. From the TacticalBattle folder go to the "Data for TB" folder, then into "Map Packs".
2. Then highlight the Getting Started Maps folder and press control + C, then control + V.
3. This creates a copy of that folder called "Getting started maps - Copy"
4. Press F2 to rename the folder to a name you like, for this example we will use the name "My Map Pack"
5. Open the "My Map Pack" folder and arrow down until you find Map Pack Settings.txt
6. Press enter on Map Pack Settings.txt to open it in notepad.
7. Change the third line to be the name of your map pack along with your name so people know you created it.
8. Press control + S to save the file, then close notepad.
9. Back in your map pack folder find the User Guide.md.html file and press delete to remove it, there may be 2 user guide files, feel free to remove both.
10. Now select File, New, Text Document.  The keyboard shortcuts for this are alt + F, then W, then T.
11. A new text document is created and you are setup to rename it.
12. Type the name "User Guide.txt" and hit enter, if you get messed up here you can always find the file and press F2 to start the rename process again.
13. Now open the User Guide with the enter key and fill it with information about your map pack.
14. Save with control + S again and close the file.  If you open the game at this point you will see your new map pack listed and when you launch the user guide it will open the one you just made.
15. Open the game and select your map pack, then arrow down to one of your maps and press control + E to enter the map editor (see the map editor section for more details).

Now you can change files in this folder as much as you want without affecting the original maps.
Read the sections below to get a better understanding of each of the files in your map pack folder and look through the files that exist in your map pack folder for examples.

## In game map editor
There is now an in game map editor which can be used to place units, structures or terrain, this is much simpler than adding each of these lines in by hand.
To enter the map editor press control + E when you are on the option to play a specific map.

Once inside the map editor you can use the following keys:

* U = Choose a unit to place.
* S = Choose a Structure to place.
* T = Choose terrain to place.
* R = Choose a region to place.
* I = Choose an item to place.
* shift + R = Rename the current unit.
* shift + T = Toggle the team of the current unit.
* control + S = Save the map.
* control + shift + R = reload the map editor, useful if you've added unit, skill, item or other files.  Note that changes are discarded unless you specifically save them.
* Escape = Return to the main menu.

Once you have a unit, structure or terrain chosen to place just press space bar or enter on any tile to place it there.
Choosing the none option removes units, structures and so forth when you press space bar.

You can place entire blocks of units, structures, terrain or regions by first marking a start position using the M key.
Then go to the other corner of the block you want to place and press shift + space bar to perform the selected placement on all those tiles.

## Name uniqueness
There are some issues in the game with certain objects having the same exact names as other objects.
As a guideline please have unique names between units, structures, effects, terrain and regions.
Additionally between skills and Points.
Skills and effects do not require name uniqueness between each other and you will see that the Getting Started maps have skills and effects with the same names.

## Flags
All the files use flags.  Flags are either a single name or a name=value pair.
For example the flag name=Ian on a unit would set the unit's name to Ian.
The flag "friendly" on a skill makes it so that skill can only be used on friendly units.
You cannot use spaces in flags.
Instead use underscores, in many places these are replaced with spaces when parsed.
Update!!  The flag format has changed, you can now have flags that take up a whole line and can contain spaces.
To do this you leave out the =.
For example:

* intro_text This is the intro text for my map.

Being able to have spaces in the flag values is very helpful.
I recommend using this over the old name=value format.
The best way to understand flags is to look at examples of them in use.  If you think a flag might be what you want but aren't sure how to use it email support@BlindAudioGames.com or ask in the AudioGames.net forum.

## Stackable Units and Structures
The game now supports having multiple units or structures on the same tile.
As mentioned in the keys section you can use tab or shift + tab to toggle through them.
There are 2 flags for maps that control how many units or structures can be on a tile at the same time, please see the map section for more details.
If you don't like the idea of stackable units and structures you can leave the feature turned off by setting both flags to 1 as is done in the getting started maps.

## Artificial Intelligence Guidelines
AI is one of the most interesting areas of computer science.
It is also one of the most challenging.
I have done my best to make the AI in the game work somewhat intelligently and to be able to use many of the skills that people create.

I have added flags for skills to hint to the AI at how they should be used and I intend on adding more flags to units so you can adjust the AI's behavior a bit more.

All that said, I am also continueing to add more features to the game that increase it's complexity and allow for much more interesting scenarios and actions that can be taken by the player.

These new features require a lot of work and getting the AI to use them somehwat intelligently is often more work than implementing the original features.

And so my guideline for making maps is that you should try to give the player interesting ways to beat  a map and units that can be used together in complex and elegant ways.
But you should give the AI more basic skills that it can use properly and give it the advantage of more powerful units or greater numbers.

We can rely on the player to come up with good strategies and ideas for beating a map but we can't do the same for AI.
Just something to keep in mind as you come up with ideas for maps so that you aren't disappointed when the AI doesn't seem to be nearly as smart as you are.

## Unseen and unexplored tiles
The game supports having unseen and unexplored tiles.  In popular mainstream games this is often called fog of war.

* An unseen tile means you can see the terrain but not enemy units on it.
* An unexplored tile means you can't see the terrain or enemy units on it.

Map creators should set the use_unseen or use_unexplored flags on their maps if they want to use these fog of war features.
If neither of those flags is set then the player will be able to see everything.

Since they are separate flags you can choose to have a map that starts explored so the player can see all terrain, but only see units when they get in sight range.
Or you can have a map where everything starts unexplored but once explored the player can see it and any enemy units on it for the rest of the game.
Or use both to get both effects.

Flying units can see over terrain that normally block sight if they can fly over it.

Note that fog of war is really something that affects the player but not the AI so much.  The AI's sight range may restrict what skills it can use but it will still come after your units even when it can't see them unless you set the ai_wait_until_enemy_in_sight flag.

## Rounds and turns
We count both rounds and turns. 
A round is a sequence in which all teams take a turn. 
A turn is when any individual team is performing actions. 

Effect durations are specified in rounds.
Durations of 1 and higher work like this: 
If I have a blaze effect that lasts only 1 round and I cast it on my turn it will last through all team turns after mine and then the next round will start and it will last through all team turns before mine and end when my turn starts again. 

A duration of 0 means it is applied but immediately removed.  Useful for effects that cause their own damage.

The timer victory and defeat flags also take a number indicating rounds. 
Setting the timer victory flag to 5 means that the player wins when their turn begins during the fifth round.
The defeat timer flag triggers at the same time but causes defeat instead.
The first round of the game is round 1.

## Top level map pack files
There are a few files that go in the root of your map pack folder.

* Map Pack Settings.txt, replaces the old author.txt file.  See the section below for it's format.
* Author.txt, deprecated and will be removed at some point, where you put the name of your map pack and who it was written by, these show up as the map pack name in game.
* Default Map Flags.txt, a list of flags that apply to all your maps, these are the same as the flags you define in the individual maps.  If you redefine a flag in a specific map it will override the default for that map.
* Default Unit Flags, a list of flags that apply to all your units, these are the same as the flags you use in the individual unit files.
* Default Structure Flags, a list of flags that apply to all your structures, these are the same as the flags you use in the individual structure files.
* User Guide, can end with .txt .html or .md.html and is the user guide presented to a player at the top of the list of your maps in game.

## Map Pack Settings
This file goes in the root of your map pack.
The file format is as follows:

* line 1 "Map pack settings"
* line 2 parser version, the current is 1
* line 3 Name of map pack and author
* line 4 Extra contact information.  Currently not used, may be used later if you want to give a brief bio or contact info.
* line 5 and beyond, Map pack flags

The map pack flags are:

* music=, let's you specify music that plays when someone as entered your map pack menu that lists your user guide and maps.
* load_scripts=, takes a comma separated list of script folders that should be loaded, for example load_scripts=craig_brett,abigail_prescott
* storyline, specifying this flag will mean that your map pack has a linear storyline, meaning that players must play through each map in turn to unlock the later maps. 
* storyline_starts_at, given a map name from a map campaign, this specifies the last pre-unlocked map name before the rest must be unlocked. So, if you give the name of your third map out of 5, the first 3 maps will appear when someone starts this map pack, and the last 2 are only revealed after beating map 3 and 4, respectively. This name should not include any numbering preceding by a dash at the beginning, and should look like the map's name in the map menu.
* multiplayer, specifies that this map pack is suitable to be played online, and will appear as a selectable map pack to use for an online game
* multiplayer_only, same as above, except this map pack should only be played online and will not appear under the "play a map campaign" i.e singleplayer

## Teams
You can specify which teams exist in your map pack, give them names and define how they feel toward other teams.
If you're just starting out I recommend using the teams that come with the getting started maps.

Team files are stored in the Teams folder of your map pack.
The name of the file is used as the name of the team minus the .txt extension.
The name is announced whenever it becomes that team's turn.
By default the team with a number=1 flag is the player controlled team and all other teams are AI controlled.
This can be changed on a per map basis using the player_team= flag.

The file format is as follows:

* line 1 "Team"
* line 2 parser version, the current is 1
* line 3 Team description, currently not used
* line 4 Team flags

The Team flags are as follows:

* number=, takes a number to identify the team.  0 is not a valid team number.
* unit_text=, takes the text that will be spoken when announcing units, such as "Good" or "Evil".
* no_turn, indicates this team should not have it's own turn.  Useful for fences or walls that can be destroyed but don't ever need to perform actions.
* friends=, takes a comma separated list of team numbers that this team is friends with.
* enemies=, takes a comma separated list of team numbers that this team is enemies with.
* color=, Takes a hex color code as used in html.  For example color=#F00 or color=#FF0000 would both cause the unit to show up red.

When defining units you must specify a team= flag on them that takes the number of the team they belong to.  All units and structures must belong to a team.

## Points
Tactical Battle supports custom points.  In the early versions of the game all map creators had to use HP, MP, and AP.
Now the points used in a map pack are configurable.
You can have points for fire mana, ice mana, and lightning mana.
Or you can have an archer who only has a set number of arrow points before he falls back to using a melee weapon.
Alchemists who have healing potion points or mech warriors that have rocket points and machine gun ammunition points.
You can even replace the action points with 2 separate movement points and action points.
If this seems overwhelming just use the existing points that are already set up in the getting started maps and come back to it after you've got some map editing experience under your belt.

Point files are stored in the Points folder of your map pack.
The name of the file is used as the name of the point minus the .txt extension.
The file format is as follows:

* line 1 "Point"
* line 2 parser version, the current is 1
* line 3 Point description
* line 4 and beyond, Point flags

The point flags are:

* announce_regen, causes the game to announce when someone regenerates this point during start or end of turn.
* allows_actions, indicates that this point allows actions and should be included when a player presses shift + A.
* hidden, indicates that this point is needed to perform a function for the map creator but should not be announced to players when they press F4 on a unit.
* at_zero=, takes a comma separated list of effects that occur when this stat reaches 0.  In the getting started maps this is used for causing death when health reaches 0.
* ordinal=, takes a number that is used to order how points are announced in unit information.  Lower numbers are announced first.
* apply_ordinal=, takes a number that is used to order how point causers are applied.  Not necessary for most situations but useful in some advanced scenarios such as when one point causer transforms a unit and you don't want a second point causer to affect the newly created unit.
* silence_changes, indicates that the game should not announce when units restore or lose any of this point
* insufficient_points_message=, allows you to specify a message to be spoken when someone tries to use a skill that the user does not have enough points for. You can use several placeholders to help with this.
	* {0} = The name of the point
	* {1} = The name of the skill
	* {2} = The amount of points required
	* {3} = The name of the unit attempting to use the skill

## Dynamic flags for damage, healing, regen and protection
These flags are dynamically named in that they have the name of the point they are affecting in them.
For instance, if you have a health point then you can define this flag on a skill to make that skill deal 5 damage.

* health_inflict=5

If you had a mana point and you instead wanted the skill to deal 5 damage to the target's mana you would do that like so:

* mana_inflict=5

Below are the dynamic point flags that can be applied to different files.
All the examples use the health point.

For Units:

* health_max=, max and starting health
* health_current=, Sets the starting health to something other than the max, a small bug in the game requires you to set this flag after setting the health_max= flag, otherwise the starting health will be the same as the max.

For Skills or Items:

* health_cost=, cost to caster

For skills, items or effects:

* health_restore=, restoration to target
* health_splash_restore=, restoration to units on tiles surrounding the target.  The splash_range= flag determines how far the splash reaches.
* health_inflict=, damage to target
* health_splash_inflict=, damage dealt to units on tiles surrounding the target.  The splash_range= flag determines how far the splash reaches.
* health_ignore_max, allows this skill to restore points passed their maximum values.

For Terrain:

* movement_step_cost=, cost to move to this tile.  This cost is not affected by modifiers.  If the cost is not met then the unit can not move to the tile which is different behavior than for the movement_step_inflict= flag.

The following flags can be placed on units, passive skills, items, effects and terrain:

* health_cost_mod=, used for things like speed or slow that adjusts the actions cost of all skills.
* health_start_turn_restore=, for regeneration at the start of a turn
* health_start_turn_inflict=, for inflicting damage at the start of a turn
* health_end_turn_restore=, same as above but for end of turn
* health_end_turn_inflict=, same as above but for end of turn
* health_step_restore=, for restoring points when the unit moves.  This applies at the destination location, which means the unit will be affected by effects and terrain on the target tile when it moves, not the one it just left.
* health_step_inflict=, for inflicting damage when the unit moves.  This applies at the destination location
* health_restore_mod=, for adjusting the power of healing skills.  Could be used on a concentration effect that causes the unit to restore more points to their targets when using healing skills.
* health_inflict_mod=, for adjusting the power of damaging skills.  Could be used on a Rage effect that causes the unit to deal more damage than usual.  Also used on the flaming weapon effect to add fire damage to your attacks.
* health_protect=, for reducing or increasing the amount of damage taken when attacked.

## Solids, Ranges and Dice for Inflict, Restore and Protect
There are 3 ways to define numbers for the inflict, restore and protect flags.

* Solid numbers, such as health_restore=10, which will always restore 10 health.
* Ranges, such as health_restore=5r15, which will restore a random number between 5 and 15.
* Dice rolls, such as health_restore=2d6, which rolls 2 6 sided dice and sums the result to get the final number.

## Damage Types
Damage Type files are stored in the Damage Types folder of your map pack.
The name of the file is used as the name of the Damage Type minus the .txt extension.
The file format is as follows:

* line 1 "Damage Type"
* line 2 parser version, the current is 1
* line 3 Damage Type description
* line 4 Damage Type flags

There is only one Damage Type flag:

* default, place this flag on the damage type you want to be the default, generally the damage type that occurs most often in your skills and effects.

You can specify a damage type whenever you use a flag that has the word inflict or protect in it.
Here's some examples:
This means the skill would deal 5 magic damage

* health_inflict=5|magic

This means the skill would deal 5 magic damage and 3 physical damage

* health_inflict=5|magic,3|physical

And this means the skill or effect would reduce the damage taken from magic attacks by 2

* health_protect=2|magic

The number and damage name are separated by a pipe (|) which is shift + the backslash key.
To specify multiple damage amounts and types you separate them with a comma (,)

If your game doesn't care about damage types then the best thing to do is define a normal damage type with the default flag.
Then whenever you leave off the pipe and damage name the default damage type is used.

So in the Getting Started maps you will see I leave the damage type off a lot when I just want to specify physical damage as that is my default damage type.
Such as:

* health_inflict=5

## Parser versions and version 10
Each type of file used to have a specific format.
Each line in the file would correspond to a certain variable that you could set.
And the bottom of the file could have any number of lines of flags.
The problem was that flag values could not have spaces in them and as the game got updated I would have to change the format of the files to support new variables that needed spaces in them.
To solve this I had a parser version as line 2 in the file and when I changed the expected format of the file the parser version would increment.
That way I could tell if you were using an old version of the file and use the old parser logic.

This was a very brittle way to work with adding new variables to the files, but better than having no parser version at all.
So after a long time I came up with a very flexible format that allows spaces in flag values and allows lists of things other than flags to be specified.
I called it parser version 10, and most of the files in the game use it, but there are a few that still use older versions like the Map Pack Settings.txt file.

Here's it's format:
* line 1 The name of the type of file, such as Map, Unit, Skill, Item etc.  This actually doesn't do anything and is left over from the early parser days.
* line 2 The number 10, which indicates that the rest of this file uses parser version 10.

Then the rest of the file is split up by list markers.
A list marker is a line that begins with a pipe (|), or vertical bar.
On most keyboards you hold shift and press back slash to make a pipe.
The most common lists are |flags and |script_flags.
When you see a line like this it means we are starting a certain list and that all the following lines will be parsed based on that list type until there is another list marker.
So each line after the |flags or |script_flags lines can be a flag name, followed by a space, followed by the value of that flag.
Script flags are defined by scripters and you can read more about them later in this document.

## Maps
Map files are stored in the Maps folder of your map pack.
The names of the files are used in the main menu of the game.
Anything preceding a dash (-) in the filename is stripped out.
This allows you to adjust the order of the maps in your map pack by putting numbers before a dash.
The file uses the parser 10 format.
It can have lists named:
* flags
* script_flags
* map_editor_marker
* units
* terrain
* regions
* items

The flags and script_flags lists should be straightforward.
The rest of the lists can be edited in the map editor so their format is not important.

The map flags are:

* width=, a number for the width of the map
* height=, a number for the height of the map
* music=, the filename of the music that should play for this map.
* intro_text, the text that should be spoken when the player first enters the map.
* victory_text, the text spoken when the player wins.
* defeat_text, the text spoken when the player loses.
* victory_conditions, a list of name=value victory conditions, described below.
* defeat_conditions, a list of name=value defeat conditions, described below.
* player_team=, takes the number of the team that will be controlled by the player.  Defaults to 1.
* units_per_tile=, a number for how many units can be on the same tile at one time.
* structures_per_tile=, a number for how many structures can be on the same tile at one time.
* opposing_forces_can_share_tiles, when set it allows opposing forces to be on the same tile at the same time.
* use_unseen, indicates that tiles become unseen whenever they are outside the player's units sight range.
* use_unexplored, indicates that tiles are unexplored until they come within the sight range of the player's units at least once.
* enable_friendly_fire, a boolean (true/false) flag that controls whether units can take splash damage from teammates on this map. Is true by default. Can be set to false either by using enable_friendly_fire=false or disable_friendly_fire.

Victory is achieved on all maps if all enemies are defeated.
Additional map victory conditions are:

* escape=, takes the name of the escape terrain followed by a pipe and then a comma separated list of all the names of the units that must be on the escape terrain to achieve victory this way.  In Escorting the princess the flag looks like this: escape=safe_zone|Loriana
* defeat=, a comma separated list of names of units that, if all are defeated, achieves victory for the player.
* timer=, takes a number that indicates the round that victory automatically occurs.

Defeat occurs on all maps if all your units are defeated.
Additional map defeat conditions are:

* death=, a comma separated list of names of units that, if any die, causes the player to be defeated.
* timer=, takes a number that indicates the round that defeat automatically occurs.

### Using sound for map text

You can use sounds to give your map text some extra flavour. You can use sound for the following flags:

* intro_text
* victory_text
* defeat_text

The syntax for doing this looks a bit different than you may have seen before, as it uses parts of the scripting engine. The syntax is as follows:

@ sound("myfile.mp3", { synchronous : true })

This can be used to give your maps briefing, or cut-scene qualities.

## Units
The unit files use the parser 10 format.

The unit flags are:

* The dynamic point flags mentioned in the Dynamic flags for damage, healing, regen and protection section.
* description, a description of the unit.
* add_skills, a comma separated list of skills the unit has, no spaces.
* team=, a number specifying which team this unit is on.  The team numbers are defined in the team files.  Currently team 1 is hard coded to be the player controlled team.
This flag can be overridden for a specific unit inside a map file.  (see the Maps section)
* name=, the name of the unit, usually specified in the map for a specific unit rather than on the unit file itself. (see the map section)
* sound=, used to look up sounds for this unit.  See the Sounds section for more details.
* flying, makes this unit a flying unit.  Flying units are allowed to move over impassable terrain.
* impassable, makes this unit or structure impassable which means that non flying units can not enter this tile.  Useful if you want structures such as walls.
* blocks_sight, stops units from seeing or using ranged skills through this structure.
* passable_terrain=, takes a comma separated list of terrains this unit can move on.  If this flag is specified then the unit can not move on any terrain except those in this list.  It also ignores impassable flags on terrain in this list.  Use the word "none" to specify that moving on tiles with no terrain is allowed. Do not use this flag if you intend to use impassable_terrain instead.
* impassable_terrain=, takes a comma separated list of terrains that this unit may not move on. If this flag is specified, this unit may move on any terrain except the ones in this list. Use the value none to prevent movement onto tiles with no terrain set. 
* ai_controlled, sets this unit to be controlled by the AI by default.
* can_toggle_ai, allows the player to change whether this unit is controlled by AI or not during gameplay.
* sight_range=, takes a number indicating how far this unit can see.
* ai_wait_until_enemy_in_sight, causes the AI to do nothing until the first time it sees an enemy.
* equip_slots=, takes a comma separated list of equip slots that this unit has.  You can define any custom slots you like.  Just be sure to make items that can go in those custom equip slots.
Optionally you can also specify starting equipment by following a slot name with a pipe and the name of the item such as: equip_slots=head|bronze_helmet,body,main_hand|long_sword,off_hand
* equip_type=, takes a comma separated list of equip type names that this unit can wear.  For example a warrior might have the following:
equip_type=plate,chain,leather,cloth
* items=, takes a comma separated list of items the unit starts out carrying.  You can follow an item name with a pipe and a quantity, such as: items=long_sword,healing_potion|5,leather_vest
* color=, Takes a hex color code as used in html.  For example color=#F00 or color=#FF0000 would both cause the unit to show up red.
This color flag overrides the team color flag.
* no_drop_items_on_death, Stops this unit from dropping items or equipment when it dies.
* friendly_type, used to announce a unit as something other than the name of it's file. For example, if you want to make a unit in a file "W Elemental.txt" for brevity, you can use "friendly_type water_elemental" to put its full name as a flag. 
* inherits=, takes a name of another unit to inherit from. See the below section for more information. 
* effect_immunities=, takes a comma separated list of effects that this unit is immune to.
* announce_death=, defaults to true, set to false to say that a unit's death should not be announced by the engine. For example, if you wanted to handle it with a scripted message, or similar.
* ignored_by_other_ai=, set to true if you want this type of unit to be ignored by AI players. They will not try to harm, heal or otherwise interact with this unit.
* ignored_for_victory_conditions=, set to true if this unit should not be considered when determining victory or defeat on maps where no special victory or defeat conditions are set.

You can also specify skill flags in a unit file if you want to modify a skill for this unit specifically.
In the Getting Started maps this is used to adjust attack range and damage with the following flags:

* attack_range=3
* attack_health_inflict=4

The skill name is used in front of an underscore followed by a flag that normally exists for skills.

### Inheritance

A more powerful technique when creating a map pack with large quantities of similar units with small differences is to use inheritance. This is best illustrated with an example. 

Here is the file for a generic melee soldier. Nothing impressive, but a good stock soldier. 

```
Unit
10
|flags
...
attack_health_inflict=2
attack_range=1
health_max=20
sound=soldier
```

Now, say we wanted to create an armoured soldier, who has a higher amount of health and is therefore tougher to kill. We could just copy and paste the other file. This is how it might look. 

```
Unit
10
|flags
...
attack_health_inflict=2
attack_range=1
health_max=30
sound=soldier
```

Which initially would work. But then, if you wanted to change something in the generic soldier, giving it 3 attack damage rather than 2, you would then have to remember to update the armoured soldier as well. Not particular hard, but let's make a third type of soldier. This one has a ranged weapon, and therefore a different sound as well. You could use this copy+paste method, like so.

```
Unit
10
|flags
...
attack_health_inflict=2
attack_range=2
health_max=20
sound=ranged_soldier
```

This is fine as is, but if you then need to change something in the generic soldier, you've now got to update it in 3 places. And this problem can grow. 

As a swifter alternative, you can use the inherits flag. This enables you to take all the properties of an existing unit, then make any changes on top of that. This is how the above units would look using inheritance. 

```
// generic soldier
Unit
10
|flags
...
attack_health_inflict=2
attack_range=1
health_max=20
sound=soldier
```

You'll notice there's no difference to make a unit able to be inherited from. 

```
// armoured soldier
Unit
10
|flags
inherits=soldier
health_max=30
```

```
// ranged soldier
Unit
10
|flags
inherits=soldier
attack_range=2
sound=ranged_soldier
```

As you can see, this is a lot cleaner, and means that any changes to the generic soldier get inherited into the armoured and ranged soldiers with no extra work. 

To make an armoured ranged soldier, it's easy. 

```
// armoured ranged soldier
Unit
10
|flags
inherits=ranged_soldier
health_max=30
```

Please bare in mind that this currently only works for units.

## Structures
The format of the structures files is the same as the Units files except that the first line says "Structure" instead of Unit.

Structures support all the same flags as units and are basically the same as units except that they have a different stack limit defined in the map flags.

Separating the semantics of structures from units should help map creators organize a little better.

Additionally, just as with the separate stack limits, other differences are likely to come up in the future and can be handled now that they are separate.

## Skills
Skills are the abilities that can be given to units in the game.

Skills use the parser 10 format.

The following flags are valid on both skills and items:

* description, a description, allows spaces.
* The dynamic point flags mentioned in the Dynamic flags for damage, healing, regen and protection section.
* friendly, indicates the skill can only be used on friendly units.
* self, indicates the skill can only be used on the unit who cast it.
* no_self_cast, used along with the friendly flag to indicate that this skill can be used on friendly units, but not the caster.
* enemy, indicates the skill can only be used on enemies.
* tile, indicates the skill is used on a tile rather than a unit.
* empty_tile, indicates the skill can only be used on empty tiles, meaning tiles that do not have a unit on them.
* only_useable_on=, takes a comma separated list of unit types.  Players and AI are only allowed to use the skill on these units.
* not_useable_on=, takes a comma separated list of unit types.  Players and AI are not allowed to use the skill on these units.
* range=, takes a number indicating how far away this skill can be used.
* min_range=, takes a number indicating the minimum distance between the user of this skill and their intended target
* splash_range=, takes a number indicating how many tiles out splash damage and effects occur from the target tile.
* sound=, The name of a sound that is played when the skill is used.  (see the Sounds section for details)
* move_self, indicates that the caster is moved to the destination tile when the skill is used.
* effects=, a comma separated list of effect names that occur on the target when the skill is used.
* remove_effects=, a comma separated list of effect names that are removed from the target when the skill is used.  Useful for cure poison type skills.
* splash_effects=, a comma separated list of effect names that occur on the splash targets when the skill is used.
* splash_remove_effects=, a comma separated list of effect names that are removed from the splash targets when the skill is used.
* self_effects=, a comma separated list of effect names that occur on the caster when the skill is used.
* self_remove_effects=, a comma separated list of effect names that are removed from the caster when the skill is used.
* summon=, takes the name of a unit or structure that is summoned to the target tile when this skill is used.  This respects stacking limits.
* no_line_of_sight, indicates this skill can be used even when the target tile is not within the caster's line of sight.
* chance=, takes a number between 1 and 100 indicating the percent chance that this skill will succeed when used.  Defaults to 100% chance.
* replace_terrain=, takes oldTerrain|newTerrain and causes the skill to replace the old terrain type with the new one.  You can specify multiple replacement groups by separating them with commas.
Such as: grass|burnt_grass,tree|burnt_tree
* can_friendly_fire, a flag that, when used, overrides the map's enable_friendly_fire setting, causing this skill to be capable of hurting friendly units if in its splash range.
* add_skills, a flag that takes a comma separated list of skill names. This skill will add the given skills to the target of this skill. In the case of an item, use of this item will grant use of the skills. 
* remove_skills, a flag that takes a comma separated list of skill names. This skill will remove the given skills from the target of this skill, if they have any of them. In the case of items, use of this item will remove the given skills from the target. 
* friendly_name, allows you to specify a different name to the name of the skill or item's file name as the name that will be used in game. 
* no_announce, skills with this flag won't have the game read out the "x uses skill on y" message. This is useful if you're using a script flag to handle your messages for more custom flavour text.
* effect_immunities=, takes a comma separated list of effect names. If used on a passive skill, this unit will be immune to these effects as long as they have the skill. If used on an item, the unit will be immune to these effects when this item is equipped.

The following flags are specific to skills only:

* passive, indicates the skill is not used but rather gives some beneficial effect to the unit who posesses it such as damage protection, the ability to fly, or modifiers to skill cost, damage, healing, or regeneration.
* move_keys, indicates that this skill should be used with the hard coded shift + arrow keys, generally reserved for the common move skill.
* key=, takes a letter which becomes the hot key for using this skill when the player has a unit selected who has the skill.
* take_item, indicates the skill is used to take an item from the ground.
* give_item, indicates the skill let's the user choose an item in their inventory and then choose another unit to give it to.
* drop_item, indicates the skill is used to drop an item.
* use_item, indicates that the skill let's you choose an item to use as though it were a skill.
* manage_equipment, causes the skill to launch the manage equipment menu for the current unit.
* self_add_skills, a flag that takes a comma separated list of skill names. This skill will add the given skills to the user of this skill
* self_remove_skills, a flag that takes a comma separated list of skill names. This skill will remove the given skills from the user of this skill

There are a few other flags for hinting to the artificial intelligence about how the skill or item is intended to be used.
If none of these hint flags are used the AI will use it's best guess.
If the best guess works well for you then you don't need to worry about these AI hint flags.

* ai_move, for skills that let the caster move.
* ai_summon, for skills that summon other units or structures
* ai_heal, for skills used to restore points to friendly units.
* ai_uncurse, for skills used to remove negative effects from friendly units.
* ai_buff, for skills used to add positive effects to friendly units.
* ai_curse, for skills used to add negative effects to enemy units.
* ai_tile_curse, for skills used to add negative effects to tiles with enemy units on them.
* ai_unbuff, for skills used to remove positive effects from enemy units.
* ai_attack, for skills used to reduce points of enemy units.
* ai_defend, for skills used on yourself to improve protection.

## Items
Items can be acquired by units and then used like skills or equipped to give beneficial modifiers to the wearer.
Items use the parser 10 format.

Note that AI will never take, use or equip items.

Items share many flags with skills.  See the Skills section for the list of flags that can be used on either.

The following flags are specific to items only:

* useable_once, allows the item to be used once and it is consumed when used.
* useable_forever, allows the item to be used any number of times without ever being consumed.
* stackable, allows multiple of this item to be combined into a single stack reducing the number of items that need to be read in your inventory.  Please do not use this on items that are equippable.
* quantity=, takes a number which is the amount of this item.  Must be used with stackable.
* equip_slots=, takes a comma separated list of equip slot names this item can be worn in.  Such as: equip_slots=main_hand,off_hand
* equip_type=, takes the name of an equip type that a unit must support in order to equip this item.  Examples are cloth, leather, chain, plate, but the names are arbitrary so you can make up any equip type you want.
You can specify more than 1 equip type by separating them with commas.  If any equip type matches between the item and the unit it becomes equippable.
* replace_skill_sound=, takes a comma separated list of skill names and replacing sounds split by a pipe.  Such as: replace_skill_sound=attack|long_sword
The specified sound will replace the normal sound of the skill when the item is equipped.
* equip_sound=, plays this sound when an item is equipped
* ranged, is prefixed by a skill name and indicates that the skill is now ranged which means it gains the benefit of any ranged modifiers.  For example: attack_ranged
* equip_add_skills, takes a comma-separated list of skill names. When this item is equipped, the unit will gain the use of these skills for as long as the item is equipped. 
* equip_remove_skills, takes a comma-separated list of skill names. When this item is equipped, the unit will lose  the use of these skills for as long as the item is equipped. 
* take_sound=, plays the given sound when an item is taken from a tile

Note that items support modifiers such as:

* chance_mod=
* range_mod=
* health_inflict_mod=
* health_restore_mod=
* health_protect=

The above modifiers only apply to the unit if it has the item equipped and can be prefixed with a skill name where appropriate to affect only that skill.

## Effects
Effects are things that can occur on a unit or tile and usually have a duration.  They are usually triggered by the use of skills but there are other ways to trigger them as well.
Effects use the parser 10 format.

The Effects flags are:

* description, a description, allows spaces.
* The dynamic point flags mentioned in the Dynamic flags for damage, healing, regen and protection section.
* tile, indicates that the effect occurs on the tile.
* unit, indicates that the effect occurs on the unit.
* duration=, takes a number indicating how many turns the effect lasts before fizzling. (see Turn Counting in the Getting Started map pack user guide)
* announce, indicates that the game should announce when this affect is applied or removed.
* splash_range=, specifies the splash range for which initial splash inflict or splash restore will be dealt by this effect.
* range_mod=, a modifier that adjusts the range of skills that have a starting range greater than 1.
* sight_range_mod=, adjusts the sight range of a unit.
* chance_mod=, adjusts the chance of skills succeeding.
* no_movement, stops the affected unit from moving.
* no_skills, stops the affected unit from using any skills.  Useful for stun effects.
* impassable, stops units from moving on to a tile with this effect.  Useful for conjured ice walls.
* fly, causes the affected unit to fly.  Flying units can move over impassable terrain.
* not_affect_flying, stops a tile effect's damage, healing, step costs and range modifiers from affecting flying units.
* blocks_sight, stops units from seeing or using ranged skills through a tile effect.
* death, causes the affected unit to die.
* sound=, takes the name of a sound file. (see the Sounds section for more details)
* step_sound=, for specifying a sound that is specifically used when a unit moves on to a tile with this effect.
* fizzle_replace_terrain=, takes oldTerrain|newTerrain and causes the skill to replace the old terrain type with the new one when the effect fizzles.  This does not occur if the effect is removed and does not fizzle due to it's duration expiring.  You can specify multiple replacement groups by separating them with commas.
Such as: grass|burnt_grass,tree|burnt_tree
* add_skills, a flag that takes a comma separated list of skill names. This effect will add the given skills to a unit with this effect for the duration of the effect. 
* remove_skills, a flag that takes a comma separated list of skill names. This effect will remove the given skills from the target of this skill, if they have any of them, for the duration of the effect. 
* hidden, causes this effect to not be read out when an effected unit has it's info read out. Useful for effects you do not want the player to be aware of. 
* friendly_name, allows you to specify a different name to the file name as the name that will be used in game. 

The modifiers on effects affect all skills by default.
You can have the modifier apply to a specific skill by prefixing it with the name of the skill.
You can use these same flags on equippable items.
So if we wanted to make some modifiers that only adjusted the attack skill they would look like this:

* attack_health_inflict_mod=5
* attack_health_restore_mod=5
* attack_actions_cost_mod=1

The above 3 modifiers are the only ones supported when specifying a skill.

## Terrain
Terrain is a (mostly) unchangeable aspect of a tile which can give benefits or detriments to unit's who are on that tile.
Terrain files use the parser 10 format.

The terrain flags are:

* description, a description, allows spaces.
* The dynamic point flags mentioned in the Dynamic flags for damage, healing, regen and protection section.
* impassable, same as for effects
* not_flyable, works just like impassable but also stops flying units.  Useful when walls are connected to ceilings and even flying units should not be able to pass them.
* blocks_sight, stops units from seeing or using ranged skills through this terrain.
* range_mod=, a modifier that adjusts the range of skills that have a starting range greater than 1.
* sight_range_mod=, adjusts the sight range of a unit.
* chance_mod=, adjusts the chance of skills succeeding.
* not_affect_flying, stops this terrains damage, healing, step costs and range modifiers from affecting flying units.
* special, indicates that this terrain is extra special and should be announced for players when they press shift + T.
* sound=, takes the name of a sound file. (see the Sounds section for more details)
* step_sound=, for specifying a sound that is specifically used when a unit moves on to a tile with this terrain.
* color=, Takes a hex color code as used in html.  For example color=#F00 or color=#FF0000 would both cause the terrain to show up red.
* friendly_name, allows you to specify a different name to the file name as the name that will be used in game for this terrain. This allows you to make subtly different terrain and give it the same name, or even hide traps on terrain.

The graphics for Tactical Battle are mostly just colored squares, but if you have a little remaining vision they can be helpful.

## Regions
Regions are just a way to label an area without changing it's terrain.
The name of the region is one of the last things announced when you move your cursor to a tile.
Regions use the parser 10 format.

There are currently no flags for regions.

## Additional features provided by scripters
The game supports scripting so that people with the ability and motivation to program new features for the game can do so.
This sort of thing is very challenging and time consuming and I appreciate the features added by the scripters.

Note that scripters can only add features through the use of events.
Events go in the flags section of files and are similar to flags except they have some additional syntax and a bit of javascript.
They also need to be placed on their own line unlike flags which can have multiple on the same line.
That said, you should still be able to use the events without any knowledge of programming by copying the examples and replacing relevant parameters as you would with flags.
Update!!  Scripters can now use script_flags instead of events which work almost exactly like flags from the map creators perspective.

Craig Brett has added features which you can learn how to use here:

[Craig Brett's charm flag and other scripts][Craig Brett link]

Victorious has contributed a suite of effect related scripts for map authors to use in their campaigns. You can read the documentation for his scripts here:

[Victorious's scripts documentation][Victorious link]

The scripting guide is intended for those with programming experience who want to help add features for the game and can be read here:

[The Scripting Guide][Scripting Guide link]

## Music and Sounds
You can place your own music in the Music folder of your map pack and your sounds in the Sounds folder of your map pack.

When specifying a music file include the extension as well.
It's a good idea to make sure all your music files are in mp3 format to conserve space.
Also note that the game will not play music with a bitrate of 320.
It has been tested with bitrates of 92, 128, and 256 and worked with all of those.

You can currently add sounds for units, terrain, skills and effects.  You do this by setting the sound= flag for that object.
For a skill the sound gets played whenever someone uses the skill.
For a tile effect the sound is played when moving over the tile with that effect.
For Terrain the sound gets played when moving over that terrain in the map if there is no unit on the same tile.
Leave off the .wav or .mp3 file extension when specifying sounds.
For units the text you specify is the prefix for 3 sounds in the sounds folder.
You can see examples of this by looking at the boar, wolf, or warrior unit files.
For the boar it has sound=boar in it's file.
Then in the Sounds folder these 3 files exist:

* boar_attack.wav
* boar_cursor.wav
* boar_death.wav

Attack and death sounds are obvious.  The cursor sound is played whenever you move your review cursor onto the unit.
Be sure to place your sound files in the Sounds folder of your map pack and not in the Sounds folder located directly in the data folder.

If using the chance= flag on your skills you can specify fail sounds which are played whenever the skill fails due to the chance= flag.
To do this simply add _fail to the end of any skill sound file, that's before the file extension.
So if I specified sound=blaze in my skill file then I might create the following 2 sound files.

* blaze.wav
* blaze_fail.wav

The first is played when the skill succeeds and the second when it fails.
You can also create a file called skill_fail.wav which is the generic skill fail sound.
So it will be played whenever a skill fails but does not have a specific fail sound associated with it.

## Random sounds
You can have more than one sound associated with an action.  You do this by naming the sounds with the exact same name except by adding numbers to the end of the name but before the file extension.
So you might have these sound files:

* warrior_cursor.wav
* warrior_cursor2.wav
* warrior_cursor3.wav

When the game decides it should play the warrior_cursor.wav file it will actually look at all 3 available sounds and randomly pick one to play.

## Color guidelines
If you are going to set colors on terrain for low vision or fully sighted players I recommend making impassable terrain a dark color and passable terrain a light color.
This will help players who need the high contrast to be able to more easily determine where there non flying units can travel.
Additionally, I recommend setting teams to a dark color so that they will stand out on passable terrain as that is the more common scenario.

## The game.config file
You may create a file in the Data For TB folder called game.config.
This file holds flags that affect the entire game.

There is currently only one interesting flag for map creators:

* verbose, causes additional information to be announced during gameplay such as dice rolls and when effects are applied.
This is useful for seeing more of what the game engine is doing when trying to figure out if your map has a bug or the main engine has a bug.

## Extra Map Creation Notes
If you've read this far and still want to make maps then you should definitely sign up for the mailing list.
I'd love to hear what you're planning on making and if you're confused about anything or need extra features added the mailing list is the place to be.
Good luck!  I am excited to see what you create!

Written by Ian Reed
